<|im_start|>system
You are an assistant which generates a program and its natural language description. The program must be in typescript which uses the Office Scripts API. The natural language description of the code must describe the intent and the impact of the code when executed on an Excel worksheet. Here are some rules which you must strictly follow when generating your response:
- The generated program must contain the APIs from the list provided.
- The programming logic must aim towards solving only a single task and not multiple compositions of tasks. The main focus of the task must be inferred from the type of APIs provided.
- If you feel it is not possible to generate a program from the set of APIs provided which aims to solve a specific task, return "no_valid" in the output and nothing else.
<|im_end|>
<|im_start|>user
ExcelScript.ConditionalFormat : An object encapsulating a conditional format's range, format, rule, and other properties.
Methods -->
- delete(): void
- getCellValue(): CellValueConditionalFormat | undefined
- getColorScale(): ColorScaleConditionalFormat | undefined
- getCustom(): CustomConditionalFormat | undefined
- getDataBar(): DataBarConditionalFormat | undefined
- getIconSet(): IconSetConditionalFormat | undefined
- getId(): string
- getPreset(): PresetCriteriaConditionalFormat | undefined
- getPriority(): number
- getRange(): Range
- getRanges(): RangeAreas
- getStopIfTrue(): boolean
- getTextComparison(): TextConditionalFormat | undefined
- getTopBottom(): TopBottomConditionalFormat | undefined
- getType(): ConditionalFormatType
- setPriority(priority: number): void
- setStopIfTrue(stopIfTrue: boolean): void

ExcelScript.TopBottomConditionalFormat : Represents a top/bottom conditional format.
Methods -->
- getFormat(): ConditionalRangeFormat
- getRule(): ConditionalTopBottomRule
- setRule(rule: ConditionalTopBottomRule): void

ExcelScript.ConditionalTopBottomRule : Represents the rule of the top/bottom conditional format.
Properties -->
- rank : The rank between 1 and 1000 for numeric ranks or 1 and 100 for percent ranks.
- type (cript!ExcelScript.ConditionalTopBottomCriterionType) : Format values based on the top or bottom rank.

ExcelScript.ConditionalTopBottomCriterionType : Represents the criteria for the above/below average conditional format type.
- bottomItems, bottomPercent, invalid, topItems, topPercent
<|im_end|>
<|im_start|>assistant
[natural language query]:
Color the lowest 5 cells in pink.
[code]:
function main(workbook: ExcelScript.Workbook) {
  // Get the current worksheet.
  let selectedSheet = workbook.getActiveWorksheet();

  // Get the used range in the worksheet.
  let range = selectedSheet.getUsedRange();

  // Set the fill color to pink for the lowest 5 values in the range.
  let conditionalFormat = range.addConditionalFormat(ExcelScript.ConditionalFormatType.topBottom)
  conditionalFormat.getTopBottom().getFormat().getFill().setColor("pink");
  conditionalFormat.getTopBottom().setRule({
    rank: 5, /* The numerical threshold. */
    type: ExcelScript.ConditionalTopBottomCriterionType.bottomItems /* The type of the top/bottom condition. */
  });
}
<|im_end|>
<|im_start|>user
<api_list>
<|im_end|>
<|im_start|>assistant
